@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.WorkflowTriggerRecurrenceArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.RecurrenceFrequency
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The workflow trigger recurrence.
 * @property endTime The end time.
 * @property frequency The frequency.
 * @property interval The interval.
 * @property schedule The recurrence schedule.
 * @property startTime The start time.
 * @property timeZone The time zone.
 */
public data class WorkflowTriggerRecurrenceArgs(
    public val endTime: Output<String>? = null,
    public val frequency: Output<Either<String, RecurrenceFrequency>>? = null,
    public val interval: Output<Int>? = null,
    public val schedule: Output<RecurrenceScheduleArgs>? = null,
    public val startTime: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.WorkflowTriggerRecurrenceArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.WorkflowTriggerRecurrenceArgs =
        com.pulumi.azurenative.logic.inputs.WorkflowTriggerRecurrenceArgs.builder()
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .frequency(
                frequency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .interval(interval?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowTriggerRecurrenceArgs].
 */
@PulumiTagMarker
public class WorkflowTriggerRecurrenceArgsBuilder internal constructor() {
    private var endTime: Output<String>? = null

    private var frequency: Output<Either<String, RecurrenceFrequency>>? = null

    private var interval: Output<Int>? = null

    private var schedule: Output<RecurrenceScheduleArgs>? = null

    private var startTime: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value The end time.
     */
    @JvmName("vajvxoukerntkfou")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value The frequency.
     */
    @JvmName("jlnalusjrqiiarwc")
    public suspend fun frequency(`value`: Output<Either<String, RecurrenceFrequency>>) {
        this.frequency = value
    }

    /**
     * @param value The interval.
     */
    @JvmName("eamlplxlfcowkqqc")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The recurrence schedule.
     */
    @JvmName("piildmrlentwrpdp")
    public suspend fun schedule(`value`: Output<RecurrenceScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value The start time.
     */
    @JvmName("lfrwevbyhxrtqwvq")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value The time zone.
     */
    @JvmName("cxnntknrirmpjgmv")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value The end time.
     */
    @JvmName("nfgguqkxoyrltjju")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value The frequency.
     */
    @JvmName("cpomffbgppavylhl")
    public suspend fun frequency(`value`: Either<String, RecurrenceFrequency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The frequency.
     */
    @JvmName("dubjaxupyedjuvba")
    public fun frequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecurrenceFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The frequency.
     */
    @JvmName("abqnldfdeushimem")
    public fun frequency(`value`: RecurrenceFrequency) {
        val toBeMapped = Either.ofRight<String, RecurrenceFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The interval.
     */
    @JvmName("ncifrowckpfnrlbx")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The recurrence schedule.
     */
    @JvmName("ocfnbafihhflslex")
    public suspend fun schedule(`value`: RecurrenceScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument The recurrence schedule.
     */
    @JvmName("kfvnynexshqwqhlv")
    public suspend fun schedule(argument: suspend RecurrenceScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = RecurrenceScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value The start time.
     */
    @JvmName("egtnqafgvxwrhtkp")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value The time zone.
     */
    @JvmName("dpkkgasioltugvmb")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): WorkflowTriggerRecurrenceArgs = WorkflowTriggerRecurrenceArgs(
        endTime = endTime,
        frequency = frequency,
        interval = interval,
        schedule = schedule,
        startTime = startTime,
        timeZone = timeZone,
    )
}
