@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12AgreementContentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The X12 agreement content.
 * @property receiveAgreement The X12 one-way receive agreement.
 * @property sendAgreement The X12 one-way send agreement.
 */
public data class X12AgreementContentArgs(
    public val receiveAgreement: Output<X12OneWayAgreementArgs>,
    public val sendAgreement: Output<X12OneWayAgreementArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12AgreementContentArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12AgreementContentArgs =
        com.pulumi.azurenative.logic.inputs.X12AgreementContentArgs.builder()
            .receiveAgreement(receiveAgreement.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sendAgreement(sendAgreement.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [X12AgreementContentArgs].
 */
@PulumiTagMarker
public class X12AgreementContentArgsBuilder internal constructor() {
    private var receiveAgreement: Output<X12OneWayAgreementArgs>? = null

    private var sendAgreement: Output<X12OneWayAgreementArgs>? = null

    /**
     * @param value The X12 one-way receive agreement.
     */
    @JvmName("cekpqagriuekrxby")
    public suspend fun receiveAgreement(`value`: Output<X12OneWayAgreementArgs>) {
        this.receiveAgreement = value
    }

    /**
     * @param value The X12 one-way send agreement.
     */
    @JvmName("xljvbhrblegtvdmj")
    public suspend fun sendAgreement(`value`: Output<X12OneWayAgreementArgs>) {
        this.sendAgreement = value
    }

    /**
     * @param value The X12 one-way receive agreement.
     */
    @JvmName("kapqvoxjipoapdtc")
    public suspend fun receiveAgreement(`value`: X12OneWayAgreementArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.receiveAgreement = mapped
    }

    /**
     * @param argument The X12 one-way receive agreement.
     */
    @JvmName("oycfkygotsntayvv")
    public suspend fun receiveAgreement(argument: suspend X12OneWayAgreementArgsBuilder.() -> Unit) {
        val toBeMapped = X12OneWayAgreementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.receiveAgreement = mapped
    }

    /**
     * @param value The X12 one-way send agreement.
     */
    @JvmName("viuwtribrgsuwiof")
    public suspend fun sendAgreement(`value`: X12OneWayAgreementArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sendAgreement = mapped
    }

    /**
     * @param argument The X12 one-way send agreement.
     */
    @JvmName("jgwgpqtnyxnmpfdx")
    public suspend fun sendAgreement(argument: suspend X12OneWayAgreementArgsBuilder.() -> Unit) {
        val toBeMapped = X12OneWayAgreementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sendAgreement = mapped
    }

    internal fun build(): X12AgreementContentArgs = X12AgreementContentArgs(
        receiveAgreement = receiveAgreement ?: throw PulumiNullFieldException("receiveAgreement"),
        sendAgreement = sendAgreement ?: throw PulumiNullFieldException("sendAgreement"),
    )
}
