@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12DelimiterOverridesArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.SegmentTerminatorSuffix
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The X12 delimiter override settings.
 * @property componentSeparator The component separator.
 * @property dataElementSeparator The data element separator.
 * @property messageId The message id.
 * @property protocolVersion The protocol version.
 * @property replaceCharacter The replacement character.
 * @property replaceSeparatorsInPayload The value indicating whether to replace separators in payload.
 * @property segmentTerminator The segment terminator.
 * @property segmentTerminatorSuffix The segment terminator suffix.
 * @property targetNamespace The target namespace on which this delimiter settings has to be applied.
 */
public data class X12DelimiterOverridesArgs(
    public val componentSeparator: Output<Int>,
    public val dataElementSeparator: Output<Int>,
    public val messageId: Output<String>? = null,
    public val protocolVersion: Output<String>? = null,
    public val replaceCharacter: Output<Int>,
    public val replaceSeparatorsInPayload: Output<Boolean>,
    public val segmentTerminator: Output<Int>,
    public val segmentTerminatorSuffix: Output<SegmentTerminatorSuffix>,
    public val targetNamespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12DelimiterOverridesArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12DelimiterOverridesArgs =
        com.pulumi.azurenative.logic.inputs.X12DelimiterOverridesArgs.builder()
            .componentSeparator(componentSeparator.applyValue({ args0 -> args0 }))
            .dataElementSeparator(dataElementSeparator.applyValue({ args0 -> args0 }))
            .messageId(messageId?.applyValue({ args0 -> args0 }))
            .protocolVersion(protocolVersion?.applyValue({ args0 -> args0 }))
            .replaceCharacter(replaceCharacter.applyValue({ args0 -> args0 }))
            .replaceSeparatorsInPayload(replaceSeparatorsInPayload.applyValue({ args0 -> args0 }))
            .segmentTerminator(segmentTerminator.applyValue({ args0 -> args0 }))
            .segmentTerminatorSuffix(
                segmentTerminatorSuffix.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetNamespace(targetNamespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [X12DelimiterOverridesArgs].
 */
@PulumiTagMarker
public class X12DelimiterOverridesArgsBuilder internal constructor() {
    private var componentSeparator: Output<Int>? = null

    private var dataElementSeparator: Output<Int>? = null

    private var messageId: Output<String>? = null

    private var protocolVersion: Output<String>? = null

    private var replaceCharacter: Output<Int>? = null

    private var replaceSeparatorsInPayload: Output<Boolean>? = null

    private var segmentTerminator: Output<Int>? = null

    private var segmentTerminatorSuffix: Output<SegmentTerminatorSuffix>? = null

    private var targetNamespace: Output<String>? = null

    /**
     * @param value The component separator.
     */
    @JvmName("fupcatjmhhkmxqob")
    public suspend fun componentSeparator(`value`: Output<Int>) {
        this.componentSeparator = value
    }

    /**
     * @param value The data element separator.
     */
    @JvmName("mggeqysfhveiurfa")
    public suspend fun dataElementSeparator(`value`: Output<Int>) {
        this.dataElementSeparator = value
    }

    /**
     * @param value The message id.
     */
    @JvmName("omlkdtvgfycslgrs")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value The protocol version.
     */
    @JvmName("giqnvdqdlmotdora")
    public suspend fun protocolVersion(`value`: Output<String>) {
        this.protocolVersion = value
    }

    /**
     * @param value The replacement character.
     */
    @JvmName("rjoemmpsniyvbnem")
    public suspend fun replaceCharacter(`value`: Output<Int>) {
        this.replaceCharacter = value
    }

    /**
     * @param value The value indicating whether to replace separators in payload.
     */
    @JvmName("mfyvsyhwwwvodxvo")
    public suspend fun replaceSeparatorsInPayload(`value`: Output<Boolean>) {
        this.replaceSeparatorsInPayload = value
    }

    /**
     * @param value The segment terminator.
     */
    @JvmName("pqgedxxhvfnmyvdm")
    public suspend fun segmentTerminator(`value`: Output<Int>) {
        this.segmentTerminator = value
    }

    /**
     * @param value The segment terminator suffix.
     */
    @JvmName("awbycicmnuabttgm")
    public suspend fun segmentTerminatorSuffix(`value`: Output<SegmentTerminatorSuffix>) {
        this.segmentTerminatorSuffix = value
    }

    /**
     * @param value The target namespace on which this delimiter settings has to be applied.
     */
    @JvmName("kyjomvpihhkqcerb")
    public suspend fun targetNamespace(`value`: Output<String>) {
        this.targetNamespace = value
    }

    /**
     * @param value The component separator.
     */
    @JvmName("ticypyfbnqfpkvdu")
    public suspend fun componentSeparator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentSeparator = mapped
    }

    /**
     * @param value The data element separator.
     */
    @JvmName("xrjqkqtlpimctygm")
    public suspend fun dataElementSeparator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataElementSeparator = mapped
    }

    /**
     * @param value The message id.
     */
    @JvmName("sqmpuabawusaahcn")
    public suspend fun messageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    /**
     * @param value The protocol version.
     */
    @JvmName("kvygmuhquiykhkmc")
    public suspend fun protocolVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolVersion = mapped
    }

    /**
     * @param value The replacement character.
     */
    @JvmName("celwfeggyynedsgt")
    public suspend fun replaceCharacter(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replaceCharacter = mapped
    }

    /**
     * @param value The value indicating whether to replace separators in payload.
     */
    @JvmName("stmgdyxqkxnkxjvh")
    public suspend fun replaceSeparatorsInPayload(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replaceSeparatorsInPayload = mapped
    }

    /**
     * @param value The segment terminator.
     */
    @JvmName("jtdhxpvqjnpqimpm")
    public suspend fun segmentTerminator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.segmentTerminator = mapped
    }

    /**
     * @param value The segment terminator suffix.
     */
    @JvmName("tnacyijtguxcbgjj")
    public suspend fun segmentTerminatorSuffix(`value`: SegmentTerminatorSuffix) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.segmentTerminatorSuffix = mapped
    }

    /**
     * @param value The target namespace on which this delimiter settings has to be applied.
     */
    @JvmName("wntjmhciajjynfbn")
    public suspend fun targetNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNamespace = mapped
    }

    internal fun build(): X12DelimiterOverridesArgs = X12DelimiterOverridesArgs(
        componentSeparator = componentSeparator ?: throw PulumiNullFieldException("componentSeparator"),
        dataElementSeparator = dataElementSeparator ?: throw
            PulumiNullFieldException("dataElementSeparator"),
        messageId = messageId,
        protocolVersion = protocolVersion,
        replaceCharacter = replaceCharacter ?: throw PulumiNullFieldException("replaceCharacter"),
        replaceSeparatorsInPayload = replaceSeparatorsInPayload ?: throw
            PulumiNullFieldException("replaceSeparatorsInPayload"),
        segmentTerminator = segmentTerminator ?: throw PulumiNullFieldException("segmentTerminator"),
        segmentTerminatorSuffix = segmentTerminatorSuffix ?: throw
            PulumiNullFieldException("segmentTerminatorSuffix"),
        targetNamespace = targetNamespace,
    )
}
