@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12EnvelopeOverrideArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.X12DateFormat
import com.pulumi.azurenative.logic.kotlin.enums.X12TimeFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The X12 envelope override settings.
 * @property dateFormat The date format.
 * @property functionalIdentifierCode The functional identifier code.
 * @property headerVersion The header version.
 * @property messageId The message id on which this envelope settings has to be applied.
 * @property protocolVersion The protocol version on which this envelope settings has to be applied.
 * @property receiverApplicationId The receiver application id.
 * @property responsibleAgencyCode The responsible agency code.
 * @property senderApplicationId The sender application id.
 * @property targetNamespace The target namespace on which this envelope settings has to be applied.
 * @property timeFormat The time format.
 */
public data class X12EnvelopeOverrideArgs(
    public val dateFormat: Output<Either<String, X12DateFormat>>,
    public val functionalIdentifierCode: Output<String>? = null,
    public val headerVersion: Output<String>,
    public val messageId: Output<String>,
    public val protocolVersion: Output<String>,
    public val receiverApplicationId: Output<String>,
    public val responsibleAgencyCode: Output<String>,
    public val senderApplicationId: Output<String>,
    public val targetNamespace: Output<String>,
    public val timeFormat: Output<Either<String, X12TimeFormat>>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12EnvelopeOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12EnvelopeOverrideArgs =
        com.pulumi.azurenative.logic.inputs.X12EnvelopeOverrideArgs.builder()
            .dateFormat(
                dateFormat.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .functionalIdentifierCode(functionalIdentifierCode?.applyValue({ args0 -> args0 }))
            .headerVersion(headerVersion.applyValue({ args0 -> args0 }))
            .messageId(messageId.applyValue({ args0 -> args0 }))
            .protocolVersion(protocolVersion.applyValue({ args0 -> args0 }))
            .receiverApplicationId(receiverApplicationId.applyValue({ args0 -> args0 }))
            .responsibleAgencyCode(responsibleAgencyCode.applyValue({ args0 -> args0 }))
            .senderApplicationId(senderApplicationId.applyValue({ args0 -> args0 }))
            .targetNamespace(targetNamespace.applyValue({ args0 -> args0 }))
            .timeFormat(
                timeFormat.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [X12EnvelopeOverrideArgs].
 */
@PulumiTagMarker
public class X12EnvelopeOverrideArgsBuilder internal constructor() {
    private var dateFormat: Output<Either<String, X12DateFormat>>? = null

    private var functionalIdentifierCode: Output<String>? = null

    private var headerVersion: Output<String>? = null

    private var messageId: Output<String>? = null

    private var protocolVersion: Output<String>? = null

    private var receiverApplicationId: Output<String>? = null

    private var responsibleAgencyCode: Output<String>? = null

    private var senderApplicationId: Output<String>? = null

    private var targetNamespace: Output<String>? = null

    private var timeFormat: Output<Either<String, X12TimeFormat>>? = null

    /**
     * @param value The date format.
     */
    @JvmName("dofirdndmmjbqfdh")
    public suspend fun dateFormat(`value`: Output<Either<String, X12DateFormat>>) {
        this.dateFormat = value
    }

    /**
     * @param value The functional identifier code.
     */
    @JvmName("vlytobdoamgnnvcd")
    public suspend fun functionalIdentifierCode(`value`: Output<String>) {
        this.functionalIdentifierCode = value
    }

    /**
     * @param value The header version.
     */
    @JvmName("tibnxidxqnuqbmsg")
    public suspend fun headerVersion(`value`: Output<String>) {
        this.headerVersion = value
    }

    /**
     * @param value The message id on which this envelope settings has to be applied.
     */
    @JvmName("tadnviovdsqhrpwu")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value The protocol version on which this envelope settings has to be applied.
     */
    @JvmName("rvyboawvqkbxffod")
    public suspend fun protocolVersion(`value`: Output<String>) {
        this.protocolVersion = value
    }

    /**
     * @param value The receiver application id.
     */
    @JvmName("gerlanesvsexvhfb")
    public suspend fun receiverApplicationId(`value`: Output<String>) {
        this.receiverApplicationId = value
    }

    /**
     * @param value The responsible agency code.
     */
    @JvmName("cbdbalupiwqfbqlf")
    public suspend fun responsibleAgencyCode(`value`: Output<String>) {
        this.responsibleAgencyCode = value
    }

    /**
     * @param value The sender application id.
     */
    @JvmName("crnixgvgtqmndbtd")
    public suspend fun senderApplicationId(`value`: Output<String>) {
        this.senderApplicationId = value
    }

    /**
     * @param value The target namespace on which this envelope settings has to be applied.
     */
    @JvmName("ndhgbvrubtpikpst")
    public suspend fun targetNamespace(`value`: Output<String>) {
        this.targetNamespace = value
    }

    /**
     * @param value The time format.
     */
    @JvmName("stngggsyswymimbl")
    public suspend fun timeFormat(`value`: Output<Either<String, X12TimeFormat>>) {
        this.timeFormat = value
    }

    /**
     * @param value The date format.
     */
    @JvmName("ooqsothxaykobvsg")
    public suspend fun dateFormat(`value`: Either<String, X12DateFormat>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dateFormat = mapped
    }

    /**
     * @param value The date format.
     */
    @JvmName("pgpkooqvjtskybuw")
    public fun dateFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, X12DateFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dateFormat = mapped
    }

    /**
     * @param value The date format.
     */
    @JvmName("verabmfgrmjvnakn")
    public fun dateFormat(`value`: X12DateFormat) {
        val toBeMapped = Either.ofRight<String, X12DateFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dateFormat = mapped
    }

    /**
     * @param value The functional identifier code.
     */
    @JvmName("misibkgxvyeehpyt")
    public suspend fun functionalIdentifierCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionalIdentifierCode = mapped
    }

    /**
     * @param value The header version.
     */
    @JvmName("badgbvmolfxmrxge")
    public suspend fun headerVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerVersion = mapped
    }

    /**
     * @param value The message id on which this envelope settings has to be applied.
     */
    @JvmName("oivprsabbuwsajvj")
    public suspend fun messageId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    /**
     * @param value The protocol version on which this envelope settings has to be applied.
     */
    @JvmName("dlpmrgdcmutdljmc")
    public suspend fun protocolVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolVersion = mapped
    }

    /**
     * @param value The receiver application id.
     */
    @JvmName("tkwhjvhvikkghfrv")
    public suspend fun receiverApplicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.receiverApplicationId = mapped
    }

    /**
     * @param value The responsible agency code.
     */
    @JvmName("ganlvvmwjkpokulo")
    public suspend fun responsibleAgencyCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responsibleAgencyCode = mapped
    }

    /**
     * @param value The sender application id.
     */
    @JvmName("eolvpbvianbkywrg")
    public suspend fun senderApplicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.senderApplicationId = mapped
    }

    /**
     * @param value The target namespace on which this envelope settings has to be applied.
     */
    @JvmName("dumpeutxjjwbonub")
    public suspend fun targetNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetNamespace = mapped
    }

    /**
     * @param value The time format.
     */
    @JvmName("hgoypnvdsdsjslqb")
    public suspend fun timeFormat(`value`: Either<String, X12TimeFormat>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeFormat = mapped
    }

    /**
     * @param value The time format.
     */
    @JvmName("wnrsnrtsbaxipvim")
    public fun timeFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, X12TimeFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeFormat = mapped
    }

    /**
     * @param value The time format.
     */
    @JvmName("tynxwpfdergjpiry")
    public fun timeFormat(`value`: X12TimeFormat) {
        val toBeMapped = Either.ofRight<String, X12TimeFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeFormat = mapped
    }

    internal fun build(): X12EnvelopeOverrideArgs = X12EnvelopeOverrideArgs(
        dateFormat = dateFormat ?: throw PulumiNullFieldException("dateFormat"),
        functionalIdentifierCode = functionalIdentifierCode,
        headerVersion = headerVersion ?: throw PulumiNullFieldException("headerVersion"),
        messageId = messageId ?: throw PulumiNullFieldException("messageId"),
        protocolVersion = protocolVersion ?: throw PulumiNullFieldException("protocolVersion"),
        receiverApplicationId = receiverApplicationId ?: throw
            PulumiNullFieldException("receiverApplicationId"),
        responsibleAgencyCode = responsibleAgencyCode ?: throw
            PulumiNullFieldException("responsibleAgencyCode"),
        senderApplicationId = senderApplicationId ?: throw PulumiNullFieldException("senderApplicationId"),
        targetNamespace = targetNamespace ?: throw PulumiNullFieldException("targetNamespace"),
        timeFormat = timeFormat ?: throw PulumiNullFieldException("timeFormat"),
    )
}
