@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12ProcessingSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The X12 processing settings.
 * @property convertImpliedDecimal The value indicating whether to convert numerical type to implied decimal.
 * @property createEmptyXmlTagsForTrailingSeparators The value indicating whether to create empty xml tags for trailing separators.
 * @property maskSecurityInfo The value indicating whether to mask security information.
 * @property preserveInterchange The value indicating whether to preserve interchange.
 * @property suspendInterchangeOnError The value indicating whether to suspend interchange on error.
 * @property useDotAsDecimalSeparator The value indicating whether to use dot as decimal separator.
 */
public data class X12ProcessingSettingsArgs(
    public val convertImpliedDecimal: Output<Boolean>,
    public val createEmptyXmlTagsForTrailingSeparators: Output<Boolean>,
    public val maskSecurityInfo: Output<Boolean>,
    public val preserveInterchange: Output<Boolean>,
    public val suspendInterchangeOnError: Output<Boolean>,
    public val useDotAsDecimalSeparator: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12ProcessingSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12ProcessingSettingsArgs =
        com.pulumi.azurenative.logic.inputs.X12ProcessingSettingsArgs.builder()
            .convertImpliedDecimal(convertImpliedDecimal.applyValue({ args0 -> args0 }))
            .createEmptyXmlTagsForTrailingSeparators(
                createEmptyXmlTagsForTrailingSeparators.applyValue({ args0 ->
                    args0
                }),
            )
            .maskSecurityInfo(maskSecurityInfo.applyValue({ args0 -> args0 }))
            .preserveInterchange(preserveInterchange.applyValue({ args0 -> args0 }))
            .suspendInterchangeOnError(suspendInterchangeOnError.applyValue({ args0 -> args0 }))
            .useDotAsDecimalSeparator(useDotAsDecimalSeparator.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [X12ProcessingSettingsArgs].
 */
@PulumiTagMarker
public class X12ProcessingSettingsArgsBuilder internal constructor() {
    private var convertImpliedDecimal: Output<Boolean>? = null

    private var createEmptyXmlTagsForTrailingSeparators: Output<Boolean>? = null

    private var maskSecurityInfo: Output<Boolean>? = null

    private var preserveInterchange: Output<Boolean>? = null

    private var suspendInterchangeOnError: Output<Boolean>? = null

    private var useDotAsDecimalSeparator: Output<Boolean>? = null

    /**
     * @param value The value indicating whether to convert numerical type to implied decimal.
     */
    @JvmName("wenxsiseseltyees")
    public suspend fun convertImpliedDecimal(`value`: Output<Boolean>) {
        this.convertImpliedDecimal = value
    }

    /**
     * @param value The value indicating whether to create empty xml tags for trailing separators.
     */
    @JvmName("wxfrjrbcqhtsnauj")
    public suspend fun createEmptyXmlTagsForTrailingSeparators(`value`: Output<Boolean>) {
        this.createEmptyXmlTagsForTrailingSeparators = value
    }

    /**
     * @param value The value indicating whether to mask security information.
     */
    @JvmName("jgqkunowgkhcpagx")
    public suspend fun maskSecurityInfo(`value`: Output<Boolean>) {
        this.maskSecurityInfo = value
    }

    /**
     * @param value The value indicating whether to preserve interchange.
     */
    @JvmName("fhpdgipnloaxbfwr")
    public suspend fun preserveInterchange(`value`: Output<Boolean>) {
        this.preserveInterchange = value
    }

    /**
     * @param value The value indicating whether to suspend interchange on error.
     */
    @JvmName("ebbolrcfahokcmnc")
    public suspend fun suspendInterchangeOnError(`value`: Output<Boolean>) {
        this.suspendInterchangeOnError = value
    }

    /**
     * @param value The value indicating whether to use dot as decimal separator.
     */
    @JvmName("uheqdxjhfxwodcmc")
    public suspend fun useDotAsDecimalSeparator(`value`: Output<Boolean>) {
        this.useDotAsDecimalSeparator = value
    }

    /**
     * @param value The value indicating whether to convert numerical type to implied decimal.
     */
    @JvmName("swxkhaklxowgasou")
    public suspend fun convertImpliedDecimal(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.convertImpliedDecimal = mapped
    }

    /**
     * @param value The value indicating whether to create empty xml tags for trailing separators.
     */
    @JvmName("qlddmryybsjolqpl")
    public suspend fun createEmptyXmlTagsForTrailingSeparators(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createEmptyXmlTagsForTrailingSeparators = mapped
    }

    /**
     * @param value The value indicating whether to mask security information.
     */
    @JvmName("swvskjhhoassoasr")
    public suspend fun maskSecurityInfo(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maskSecurityInfo = mapped
    }

    /**
     * @param value The value indicating whether to preserve interchange.
     */
    @JvmName("pamwylmlidysbjbv")
    public suspend fun preserveInterchange(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preserveInterchange = mapped
    }

    /**
     * @param value The value indicating whether to suspend interchange on error.
     */
    @JvmName("hqfiaiuamvydxcwj")
    public suspend fun suspendInterchangeOnError(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.suspendInterchangeOnError = mapped
    }

    /**
     * @param value The value indicating whether to use dot as decimal separator.
     */
    @JvmName("eisrjnrutntwbwnc")
    public suspend fun useDotAsDecimalSeparator(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useDotAsDecimalSeparator = mapped
    }

    internal fun build(): X12ProcessingSettingsArgs = X12ProcessingSettingsArgs(
        convertImpliedDecimal = convertImpliedDecimal ?: throw
            PulumiNullFieldException("convertImpliedDecimal"),
        createEmptyXmlTagsForTrailingSeparators = createEmptyXmlTagsForTrailingSeparators ?: throw
            PulumiNullFieldException("createEmptyXmlTagsForTrailingSeparators"),
        maskSecurityInfo = maskSecurityInfo ?: throw PulumiNullFieldException("maskSecurityInfo"),
        preserveInterchange = preserveInterchange ?: throw PulumiNullFieldException("preserveInterchange"),
        suspendInterchangeOnError = suspendInterchangeOnError ?: throw
            PulumiNullFieldException("suspendInterchangeOnError"),
        useDotAsDecimalSeparator = useDotAsDecimalSeparator ?: throw
            PulumiNullFieldException("useDotAsDecimalSeparator"),
    )
}
