@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12SecuritySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The X12 agreement security settings.
 * @property authorizationQualifier The authorization qualifier.
 * @property authorizationValue The authorization value.
 * @property passwordValue The password value.
 * @property securityQualifier The security qualifier.
 */
public data class X12SecuritySettingsArgs(
    public val authorizationQualifier: Output<String>,
    public val authorizationValue: Output<String>? = null,
    public val passwordValue: Output<String>? = null,
    public val securityQualifier: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12SecuritySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12SecuritySettingsArgs =
        com.pulumi.azurenative.logic.inputs.X12SecuritySettingsArgs.builder()
            .authorizationQualifier(authorizationQualifier.applyValue({ args0 -> args0 }))
            .authorizationValue(authorizationValue?.applyValue({ args0 -> args0 }))
            .passwordValue(passwordValue?.applyValue({ args0 -> args0 }))
            .securityQualifier(securityQualifier.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [X12SecuritySettingsArgs].
 */
@PulumiTagMarker
public class X12SecuritySettingsArgsBuilder internal constructor() {
    private var authorizationQualifier: Output<String>? = null

    private var authorizationValue: Output<String>? = null

    private var passwordValue: Output<String>? = null

    private var securityQualifier: Output<String>? = null

    /**
     * @param value The authorization qualifier.
     */
    @JvmName("lguviymsowmdfikb")
    public suspend fun authorizationQualifier(`value`: Output<String>) {
        this.authorizationQualifier = value
    }

    /**
     * @param value The authorization value.
     */
    @JvmName("pekcrcrraldvpapl")
    public suspend fun authorizationValue(`value`: Output<String>) {
        this.authorizationValue = value
    }

    /**
     * @param value The password value.
     */
    @JvmName("dhvhsjpillclnamf")
    public suspend fun passwordValue(`value`: Output<String>) {
        this.passwordValue = value
    }

    /**
     * @param value The security qualifier.
     */
    @JvmName("dlurflfllpacfmti")
    public suspend fun securityQualifier(`value`: Output<String>) {
        this.securityQualifier = value
    }

    /**
     * @param value The authorization qualifier.
     */
    @JvmName("tclowgdxggjwtkma")
    public suspend fun authorizationQualifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationQualifier = mapped
    }

    /**
     * @param value The authorization value.
     */
    @JvmName("dfbcxirloqrpokda")
    public suspend fun authorizationValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationValue = mapped
    }

    /**
     * @param value The password value.
     */
    @JvmName("vasbvxyexprxjtjo")
    public suspend fun passwordValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordValue = mapped
    }

    /**
     * @param value The security qualifier.
     */
    @JvmName("frafeqjersxljpsx")
    public suspend fun securityQualifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityQualifier = mapped
    }

    internal fun build(): X12SecuritySettingsArgs = X12SecuritySettingsArgs(
        authorizationQualifier = authorizationQualifier ?: throw
            PulumiNullFieldException("authorizationQualifier"),
        authorizationValue = authorizationValue,
        passwordValue = passwordValue,
        securityQualifier = securityQualifier ?: throw PulumiNullFieldException("securityQualifier"),
    )
}
