@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The AS2 agreement acknowledgement connection settings.
 * @property ignoreCertificateNameMismatch Indicates whether to ignore mismatch in certificate name.
 * @property keepHttpConnectionAlive Indicates whether to keep the connection alive.
 * @property supportHttpStatusCodeContinue Indicates whether to support HTTP status code 'CONTINUE'.
 * @property unfoldHttpHeaders Indicates whether to unfold the HTTP headers.
 */
public data class AS2AcknowledgementConnectionSettingsResponse(
    public val ignoreCertificateNameMismatch: Boolean,
    public val keepHttpConnectionAlive: Boolean,
    public val supportHttpStatusCodeContinue: Boolean,
    public val unfoldHttpHeaders: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AS2AcknowledgementConnectionSettingsResponse): AS2AcknowledgementConnectionSettingsResponse = AS2AcknowledgementConnectionSettingsResponse(
            ignoreCertificateNameMismatch = javaType.ignoreCertificateNameMismatch(),
            keepHttpConnectionAlive = javaType.keepHttpConnectionAlive(),
            supportHttpStatusCodeContinue = javaType.supportHttpStatusCodeContinue(),
            unfoldHttpHeaders = javaType.unfoldHttpHeaders(),
        )
    }
}
