@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress

/**
 * The integration account AS2 agreement content.
 * @property receiveAgreement The AS2 one-way receive agreement.
 * @property sendAgreement The AS2 one-way send agreement.
 */
public data class AS2AgreementContentResponse(
    public val receiveAgreement: AS2OneWayAgreementResponse,
    public val sendAgreement: AS2OneWayAgreementResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AS2AgreementContentResponse): AS2AgreementContentResponse = AS2AgreementContentResponse(
            receiveAgreement = javaType.receiveAgreement().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.AS2OneWayAgreementResponse.Companion.toKotlin(args0)
            }),
            sendAgreement = javaType.sendAgreement().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.AS2OneWayAgreementResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
