@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The AS2 agreement error settings.
 * @property resendIfMDNNotReceived The value indicating whether to resend message If MDN is not received.
 * @property suspendDuplicateMessage The value indicating whether to suspend duplicate message.
 */
public data class AS2ErrorSettingsResponse(
    public val resendIfMDNNotReceived: Boolean,
    public val suspendDuplicateMessage: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AS2ErrorSettingsResponse): AS2ErrorSettingsResponse = AS2ErrorSettingsResponse(
            resendIfMDNNotReceived = javaType.resendIfMDNNotReceived(),
            suspendDuplicateMessage = javaType.suspendDuplicateMessage(),
        )
    }
}
