@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The AS2 agreement mdn settings.
 * @property dispositionNotificationTo The disposition notification to header value.
 * @property mdnText The MDN text.
 * @property micHashingAlgorithm The signing or hashing algorithm.
 * @property needMDN The value indicating whether to send or request a MDN.
 * @property receiptDeliveryUrl The receipt delivery URL.
 * @property sendInboundMDNToMessageBox The value indicating whether to send inbound MDN to message box.
 * @property sendMDNAsynchronously The value indicating whether to send the asynchronous MDN.
 * @property signMDN The value indicating whether the MDN needs to be signed or not.
 * @property signOutboundMDNIfOptional The value indicating whether to sign the outbound MDN if optional.
 */
public data class AS2MdnSettingsResponse(
    public val dispositionNotificationTo: String? = null,
    public val mdnText: String? = null,
    public val micHashingAlgorithm: String,
    public val needMDN: Boolean,
    public val receiptDeliveryUrl: String? = null,
    public val sendInboundMDNToMessageBox: Boolean,
    public val sendMDNAsynchronously: Boolean,
    public val signMDN: Boolean,
    public val signOutboundMDNIfOptional: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AS2MdnSettingsResponse): AS2MdnSettingsResponse = AS2MdnSettingsResponse(
            dispositionNotificationTo = javaType.dispositionNotificationTo().map({ args0 ->
                args0
            }).orElse(null),
            mdnText = javaType.mdnText().map({ args0 -> args0 }).orElse(null),
            micHashingAlgorithm = javaType.micHashingAlgorithm(),
            needMDN = javaType.needMDN(),
            receiptDeliveryUrl = javaType.receiptDeliveryUrl().map({ args0 -> args0 }).orElse(null),
            sendInboundMDNToMessageBox = javaType.sendInboundMDNToMessageBox(),
            sendMDNAsynchronously = javaType.sendMDNAsynchronously(),
            signMDN = javaType.signMDN(),
            signOutboundMDNIfOptional = javaType.signOutboundMDNIfOptional(),
        )
    }
}
