@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The AS2 agreement message connection settings.
 * @property ignoreCertificateNameMismatch The value indicating whether to ignore mismatch in certificate name.
 * @property keepHttpConnectionAlive The value indicating whether to keep the connection alive.
 * @property supportHttpStatusCodeContinue The value indicating whether to support HTTP status code 'CONTINUE'.
 * @property unfoldHttpHeaders The value indicating whether to unfold the HTTP headers.
 */
public data class AS2MessageConnectionSettingsResponse(
    public val ignoreCertificateNameMismatch: Boolean,
    public val keepHttpConnectionAlive: Boolean,
    public val supportHttpStatusCodeContinue: Boolean,
    public val unfoldHttpHeaders: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AS2MessageConnectionSettingsResponse): AS2MessageConnectionSettingsResponse = AS2MessageConnectionSettingsResponse(
            ignoreCertificateNameMismatch = javaType.ignoreCertificateNameMismatch(),
            keepHttpConnectionAlive = javaType.keepHttpConnectionAlive(),
            supportHttpStatusCodeContinue = javaType.supportHttpStatusCodeContinue(),
            unfoldHttpHeaders = javaType.unfoldHttpHeaders(),
        )
    }
}
