@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress

/**
 * The integration account AS2 one-way agreement.
 * @property protocolSettings The AS2 protocol settings.
 * @property receiverBusinessIdentity The receiver business identity
 * @property senderBusinessIdentity The sender business identity
 */
public data class AS2OneWayAgreementResponse(
    public val protocolSettings: AS2ProtocolSettingsResponse,
    public val receiverBusinessIdentity: BusinessIdentityResponse,
    public val senderBusinessIdentity: BusinessIdentityResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AS2OneWayAgreementResponse): AS2OneWayAgreementResponse = AS2OneWayAgreementResponse(
            protocolSettings = javaType.protocolSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.AS2ProtocolSettingsResponse.Companion.toKotlin(args0)
            }),
            receiverBusinessIdentity = javaType.receiverBusinessIdentity().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.BusinessIdentityResponse.Companion.toKotlin(args0)
            }),
            senderBusinessIdentity = javaType.senderBusinessIdentity().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.BusinessIdentityResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
