@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The AS2 agreement security settings.
 * @property enableNRRForInboundDecodedMessages The value indicating whether to enable NRR for inbound decoded messages.
 * @property enableNRRForInboundEncodedMessages The value indicating whether to enable NRR for inbound encoded messages.
 * @property enableNRRForInboundMDN The value indicating whether to enable NRR for inbound MDN.
 * @property enableNRRForOutboundDecodedMessages The value indicating whether to enable NRR for outbound decoded messages.
 * @property enableNRRForOutboundEncodedMessages The value indicating whether to enable NRR for outbound encoded messages.
 * @property enableNRRForOutboundMDN The value indicating whether to enable NRR for outbound MDN.
 * @property encryptionCertificateName The name of the encryption certificate.
 * @property overrideGroupSigningCertificate The value indicating whether to send or request a MDN.
 * @property sha2AlgorithmFormat The Sha2 algorithm format. Valid values are Sha2, ShaHashSize, ShaHyphenHashSize, Sha2UnderscoreHashSize.
 * @property signingCertificateName The name of the signing certificate.
 */
public data class AS2SecuritySettingsResponse(
    public val enableNRRForInboundDecodedMessages: Boolean,
    public val enableNRRForInboundEncodedMessages: Boolean,
    public val enableNRRForInboundMDN: Boolean,
    public val enableNRRForOutboundDecodedMessages: Boolean,
    public val enableNRRForOutboundEncodedMessages: Boolean,
    public val enableNRRForOutboundMDN: Boolean,
    public val encryptionCertificateName: String? = null,
    public val overrideGroupSigningCertificate: Boolean,
    public val sha2AlgorithmFormat: String? = null,
    public val signingCertificateName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AS2SecuritySettingsResponse): AS2SecuritySettingsResponse = AS2SecuritySettingsResponse(
            enableNRRForInboundDecodedMessages = javaType.enableNRRForInboundDecodedMessages(),
            enableNRRForInboundEncodedMessages = javaType.enableNRRForInboundEncodedMessages(),
            enableNRRForInboundMDN = javaType.enableNRRForInboundMDN(),
            enableNRRForOutboundDecodedMessages = javaType.enableNRRForOutboundDecodedMessages(),
            enableNRRForOutboundEncodedMessages = javaType.enableNRRForOutboundEncodedMessages(),
            enableNRRForOutboundMDN = javaType.enableNRRForOutboundMDN(),
            encryptionCertificateName = javaType.encryptionCertificateName().map({ args0 ->
                args0
            }).orElse(null),
            overrideGroupSigningCertificate = javaType.overrideGroupSigningCertificate(),
            sha2AlgorithmFormat = javaType.sha2AlgorithmFormat().map({ args0 -> args0 }).orElse(null),
            signingCertificateName = javaType.signingCertificateName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
