@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The AS2 agreement validation settings.
 * @property checkCertificateRevocationListOnReceive The value indicating whether to check for certificate revocation list on receive.
 * @property checkCertificateRevocationListOnSend The value indicating whether to check for certificate revocation list on send.
 * @property checkDuplicateMessage The value indicating whether to check for duplicate message.
 * @property compressMessage The value indicating whether the message has to be compressed.
 * @property encryptMessage The value indicating whether the message has to be encrypted.
 * @property encryptionAlgorithm The encryption algorithm.
 * @property interchangeDuplicatesValidityDays The number of days to look back for duplicate interchange.
 * @property overrideMessageProperties The value indicating whether to override incoming message properties with those in agreement.
 * @property signMessage The value indicating whether the message has to be signed.
 * @property signingAlgorithm The signing algorithm.
 */
public data class AS2ValidationSettingsResponse(
    public val checkCertificateRevocationListOnReceive: Boolean,
    public val checkCertificateRevocationListOnSend: Boolean,
    public val checkDuplicateMessage: Boolean,
    public val compressMessage: Boolean,
    public val encryptMessage: Boolean,
    public val encryptionAlgorithm: String,
    public val interchangeDuplicatesValidityDays: Int,
    public val overrideMessageProperties: Boolean,
    public val signMessage: Boolean,
    public val signingAlgorithm: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AS2ValidationSettingsResponse): AS2ValidationSettingsResponse = AS2ValidationSettingsResponse(
            checkCertificateRevocationListOnReceive = javaType.checkCertificateRevocationListOnReceive(),
            checkCertificateRevocationListOnSend = javaType.checkCertificateRevocationListOnSend(),
            checkDuplicateMessage = javaType.checkDuplicateMessage(),
            compressMessage = javaType.compressMessage(),
            encryptMessage = javaType.encryptMessage(),
            encryptionAlgorithm = javaType.encryptionAlgorithm(),
            interchangeDuplicatesValidityDays = javaType.interchangeDuplicatesValidityDays(),
            overrideMessageProperties = javaType.overrideMessageProperties(),
            signMessage = javaType.signMessage(),
            signingAlgorithm = javaType.signingAlgorithm().map({ args0 -> args0 }).orElse(null),
        )
    }
}
