@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The API deployment parameter metadata.
 * @property description The description.
 * @property displayName The display name.
 * @property isRequired Indicates whether its required.
 * @property type The type.
 * @property visibility The visibility.
 */
public data class ApiDeploymentParameterMetadataResponse(
    public val description: String? = null,
    public val displayName: String? = null,
    public val isRequired: Boolean? = null,
    public val type: String? = null,
    public val visibility: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.ApiDeploymentParameterMetadataResponse): ApiDeploymentParameterMetadataResponse = ApiDeploymentParameterMetadataResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            isRequired = javaType.isRequired().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            visibility = javaType.visibility().map({ args0 -> args0 }).orElse(null),
        )
    }
}
