@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Api resource definition.
 * @property modifiedSwaggerUrl The modified swagger url.
 * @property originalSwaggerUrl The original swagger url.
 */
public data class ApiResourceDefinitionsResponse(
    public val modifiedSwaggerUrl: String? = null,
    public val originalSwaggerUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.ApiResourceDefinitionsResponse): ApiResourceDefinitionsResponse = ApiResourceDefinitionsResponse(
            modifiedSwaggerUrl = javaType.modifiedSwaggerUrl().map({ args0 -> args0 }).orElse(null),
            originalSwaggerUrl = javaType.originalSwaggerUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
