@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The API general information.
 * @property description The description.
 * @property displayName The display name.
 * @property iconUrl The icon url.
 * @property releaseTag The release tag.
 * @property termsOfUseUrl The terms of use url.
 * @property tier The tier.
 */
public data class ApiResourceGeneralInformationResponse(
    public val description: String? = null,
    public val displayName: String? = null,
    public val iconUrl: String? = null,
    public val releaseTag: String? = null,
    public val termsOfUseUrl: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.ApiResourceGeneralInformationResponse): ApiResourceGeneralInformationResponse = ApiResourceGeneralInformationResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            iconUrl = javaType.iconUrl().map({ args0 -> args0 }).orElse(null),
            releaseTag = javaType.releaseTag().map({ args0 -> args0 }).orElse(null),
            termsOfUseUrl = javaType.termsOfUseUrl().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
