@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The api resource metadata.
 * @property apiType The api type.
 * @property brandColor The brand color.
 * @property connectionType The connection type.
 * @property deploymentParameters The connector deployment parameters metadata.
 * @property hideKey The hide key.
 * @property provisioningState The provisioning state.
 * @property source The source.
 * @property tags The tags.
 * @property wsdlImportMethod The WSDL import method.
 * @property wsdlService The WSDL service.
 */
public data class ApiResourceMetadataResponse(
    public val apiType: String? = null,
    public val brandColor: String? = null,
    public val connectionType: String? = null,
    public val deploymentParameters: ApiDeploymentParameterMetadataSetResponse? = null,
    public val hideKey: String? = null,
    public val provisioningState: String? = null,
    public val source: String? = null,
    public val tags: Map<String, String>? = null,
    public val wsdlImportMethod: String? = null,
    public val wsdlService: WsdlServiceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.ApiResourceMetadataResponse): ApiResourceMetadataResponse = ApiResourceMetadataResponse(
            apiType = javaType.apiType().map({ args0 -> args0 }).orElse(null),
            brandColor = javaType.brandColor().map({ args0 -> args0 }).orElse(null),
            connectionType = javaType.connectionType().map({ args0 -> args0 }).orElse(null),
            deploymentParameters = javaType.deploymentParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ApiDeploymentParameterMetadataSetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hideKey = javaType.hideKey().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            wsdlImportMethod = javaType.wsdlImportMethod().map({ args0 -> args0 }).orElse(null),
            wsdlService = javaType.wsdlService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.WsdlServiceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
