@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The API resource policies.
 * @property content The API level only policies XML as embedded content.
 * @property contentLink The content link to the policies.
 */
public data class ApiResourcePoliciesResponse(
    public val content: String? = null,
    public val contentLink: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.ApiResourcePoliciesResponse): ApiResourcePoliciesResponse = ApiResourcePoliciesResponse(
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            contentLink = javaType.contentLink().map({ args0 -> args0 }).orElse(null),
        )
    }
}
