@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The B2B partner content.
 * @property businessIdentities The list of partner business identities.
 */
public data class B2BPartnerContentResponse(
    public val businessIdentities: List<BusinessIdentityResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.B2BPartnerContentResponse): B2BPartnerContentResponse = B2BPartnerContentResponse(
            businessIdentities = javaType.businessIdentities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.BusinessIdentityResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
