@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The batch configuration properties definition.
 * @property batchGroupName The name of the batch group.
 * @property changedTime The artifact changed time.
 * @property createdTime The artifact creation time.
 * @property metadata
 * @property releaseCriteria The batch release criteria.
 */
public data class BatchConfigurationPropertiesResponse(
    public val batchGroupName: String,
    public val changedTime: String? = null,
    public val createdTime: String? = null,
    public val metadata: Any? = null,
    public val releaseCriteria: BatchReleaseCriteriaResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.BatchConfigurationPropertiesResponse): BatchConfigurationPropertiesResponse = BatchConfigurationPropertiesResponse(
            batchGroupName = javaType.batchGroupName(),
            changedTime = javaType.changedTime().map({ args0 -> args0 }).orElse(null),
            createdTime = javaType.createdTime().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            releaseCriteria = javaType.releaseCriteria().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.BatchReleaseCriteriaResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
