@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The content hash.
 * @property algorithm The algorithm of the content hash.
 * @property value The value of the content hash.
 */
public data class ContentHashResponse(
    public val algorithm: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.ContentHashResponse): ContentHashResponse = ContentHashResponse(
            algorithm = javaType.algorithm().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
