@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The content link.
 * @property contentHash The content hash.
 * @property contentSize The content size.
 * @property contentVersion The content version.
 * @property metadata The metadata.
 * @property uri The content link URI.
 */
public data class ContentLinkResponse(
    public val contentHash: ContentHashResponse,
    public val contentSize: Double,
    public val contentVersion: String,
    public val metadata: Any,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.ContentLinkResponse): ContentLinkResponse = ContentLinkResponse(
            contentHash = javaType.contentHash().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.ContentHashResponse.Companion.toKotlin(args0)
            }),
            contentSize = javaType.contentSize(),
            contentVersion = javaType.contentVersion(),
            metadata = javaType.metadata(),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
