@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The Edifact agreement framing settings.
 * @property characterEncoding The character encoding.
 * @property characterSet The EDIFACT frame setting characterSet.
 * @property componentSeparator The component separator.
 * @property dataElementSeparator The data element separator.
 * @property decimalPointIndicator The EDIFACT frame setting decimal indicator.
 * @property protocolVersion The protocol version.
 * @property releaseIndicator The release indicator.
 * @property repetitionSeparator The repetition separator.
 * @property segmentTerminator The segment terminator.
 * @property segmentTerminatorSuffix The EDIFACT frame setting segment terminator suffix.
 * @property serviceCodeListDirectoryVersion The service code list directory version.
 */
public data class EdifactFramingSettingsResponse(
    public val characterEncoding: String? = null,
    public val characterSet: String,
    public val componentSeparator: Int,
    public val dataElementSeparator: Int,
    public val decimalPointIndicator: String,
    public val protocolVersion: Int,
    public val releaseIndicator: Int,
    public val repetitionSeparator: Int,
    public val segmentTerminator: Int,
    public val segmentTerminatorSuffix: String,
    public val serviceCodeListDirectoryVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.EdifactFramingSettingsResponse): EdifactFramingSettingsResponse = EdifactFramingSettingsResponse(
            characterEncoding = javaType.characterEncoding().map({ args0 -> args0 }).orElse(null),
            characterSet = javaType.characterSet(),
            componentSeparator = javaType.componentSeparator(),
            dataElementSeparator = javaType.dataElementSeparator(),
            decimalPointIndicator = javaType.decimalPointIndicator(),
            protocolVersion = javaType.protocolVersion(),
            releaseIndicator = javaType.releaseIndicator(),
            repetitionSeparator = javaType.repetitionSeparator(),
            segmentTerminator = javaType.segmentTerminator(),
            segmentTerminatorSuffix = javaType.segmentTerminatorSuffix(),
            serviceCodeListDirectoryVersion = javaType.serviceCodeListDirectoryVersion().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
