@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress

/**
 * The Edifact one way agreement.
 * @property protocolSettings The EDIFACT protocol settings.
 * @property receiverBusinessIdentity The receiver business identity
 * @property senderBusinessIdentity The sender business identity
 */
public data class EdifactOneWayAgreementResponse(
    public val protocolSettings: EdifactProtocolSettingsResponse,
    public val receiverBusinessIdentity: BusinessIdentityResponse,
    public val senderBusinessIdentity: BusinessIdentityResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.EdifactOneWayAgreementResponse): EdifactOneWayAgreementResponse = EdifactOneWayAgreementResponse(
            protocolSettings = javaType.protocolSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.EdifactProtocolSettingsResponse.Companion.toKotlin(args0)
            }),
            receiverBusinessIdentity = javaType.receiverBusinessIdentity().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.BusinessIdentityResponse.Companion.toKotlin(args0)
            }),
            senderBusinessIdentity = javaType.senderBusinessIdentity().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.BusinessIdentityResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
