@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The Edifact agreement protocol settings.
 * @property createEmptyXmlTagsForTrailingSeparators The value indicating whether to create empty xml tags for trailing separators.
 * @property maskSecurityInfo The value indicating whether to mask security information.
 * @property preserveInterchange The value indicating whether to preserve interchange.
 * @property suspendInterchangeOnError The value indicating whether to suspend interchange on error.
 * @property useDotAsDecimalSeparator The value indicating whether to use dot as decimal separator.
 */
public data class EdifactProcessingSettingsResponse(
    public val createEmptyXmlTagsForTrailingSeparators: Boolean,
    public val maskSecurityInfo: Boolean,
    public val preserveInterchange: Boolean,
    public val suspendInterchangeOnError: Boolean,
    public val useDotAsDecimalSeparator: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.EdifactProcessingSettingsResponse): EdifactProcessingSettingsResponse = EdifactProcessingSettingsResponse(
            createEmptyXmlTagsForTrailingSeparators = javaType.createEmptyXmlTagsForTrailingSeparators(),
            maskSecurityInfo = javaType.maskSecurityInfo(),
            preserveInterchange = javaType.preserveInterchange(),
            suspendInterchangeOnError = javaType.suspendInterchangeOnError(),
            useDotAsDecimalSeparator = javaType.useDotAsDecimalSeparator(),
        )
    }
}
