@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The expression.
 * @property error The azure resource error info.
 * @property subexpressions The sub expressions.
 * @property text The text.
 * @property value
 */
public data class ExpressionResponse(
    public val error: AzureResourceErrorInfoResponse? = null,
    public val subexpressions: List<ExpressionResponse>? = null,
    public val text: String? = null,
    public val `value`: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.ExpressionResponse): ExpressionResponse = ExpressionResponse(
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.AzureResourceErrorInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subexpressions = javaType.subexpressions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ExpressionResponse.Companion.toKotlin(args0)
                })
            }),
            text = javaType.text().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
