@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The access control configuration policy.
 * @property allowedCallerIpAddresses The allowed caller IP address ranges.
 * @property openAuthenticationPolicies The authentication policies for workflow.
 */
public data class FlowAccessControlConfigurationPolicyResponse(
    public val allowedCallerIpAddresses: List<IpAddressRangeResponse>? = null,
    public val openAuthenticationPolicies: OpenAuthenticationAccessPoliciesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.FlowAccessControlConfigurationPolicyResponse): FlowAccessControlConfigurationPolicyResponse = FlowAccessControlConfigurationPolicyResponse(
            allowedCallerIpAddresses = javaType.allowedCallerIpAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.IpAddressRangeResponse.Companion.toKotlin(args0)
                })
            }),
            openAuthenticationPolicies = javaType.openAuthenticationPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.OpenAuthenticationAccessPoliciesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
