@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress

/**
 * The access control configuration.
 * @property actions The access control configuration for workflow actions.
 * @property contents The access control configuration for accessing workflow run contents.
 * @property triggers The access control configuration for invoking workflow triggers.
 * @property workflowManagement The access control configuration for workflow management.
 */
public data class FlowAccessControlConfigurationResponse(
    public val actions: FlowAccessControlConfigurationPolicyResponse? = null,
    public val contents: FlowAccessControlConfigurationPolicyResponse? = null,
    public val triggers: FlowAccessControlConfigurationPolicyResponse? = null,
    public val workflowManagement: FlowAccessControlConfigurationPolicyResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.FlowAccessControlConfigurationResponse): FlowAccessControlConfigurationResponse = FlowAccessControlConfigurationResponse(
            actions = javaType.actions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.FlowAccessControlConfigurationPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            contents = javaType.contents().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.FlowAccessControlConfigurationPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            triggers = javaType.triggers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.FlowAccessControlConfigurationPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workflowManagement = javaType.workflowManagement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.FlowAccessControlConfigurationPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
