@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress

/**
 * The endpoints configuration.
 * @property connector The connector endpoints.
 * @property workflow The workflow endpoints.
 */
public data class FlowEndpointsConfigurationResponse(
    public val connector: FlowEndpointsResponse? = null,
    public val workflow: FlowEndpointsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.FlowEndpointsConfigurationResponse): FlowEndpointsConfigurationResponse = FlowEndpointsConfigurationResponse(
            connector = javaType.connector().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.FlowEndpointsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workflow = javaType.workflow().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.FlowEndpointsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
