@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The assembly definition.
 * @property id The resource id.
 * @property location The resource location.
 * @property name Gets the resource name.
 * @property properties The assembly properties.
 * @property tags The resource tags.
 * @property type Gets the resource type.
 */
public data class GetIntegrationAccountAssemblyResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: AssemblyPropertiesResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetIntegrationAccountAssemblyResult): GetIntegrationAccountAssemblyResult = GetIntegrationAccountAssemblyResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.AssemblyPropertiesResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
