@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The batch configuration resource definition.
 * @property id The resource id.
 * @property location The resource location.
 * @property name Gets the resource name.
 * @property properties The batch configuration properties.
 * @property tags The resource tags.
 * @property type Gets the resource type.
 */
public data class GetIntegrationAccountBatchConfigurationResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: BatchConfigurationPropertiesResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetIntegrationAccountBatchConfigurationResult): GetIntegrationAccountBatchConfigurationResult =
            GetIntegrationAccountBatchConfigurationResult(
                id = javaType.id(),
                location = javaType.location().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                properties = javaType.properties().let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.BatchConfigurationPropertiesResponse.Companion.toKotlin(args0)
                }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                type = javaType.type(),
            )
    }
}
