@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The integration account certificate.
 * @property changedTime The changed time.
 * @property createdTime The created time.
 * @property id The resource id.
 * @property key The key details in the key vault.
 * @property location The resource location.
 * @property metadata The metadata.
 * @property name Gets the resource name.
 * @property publicCertificate The public certificate.
 * @property tags The resource tags.
 * @property type Gets the resource type.
 */
public data class GetIntegrationAccountCertificateResult(
    public val changedTime: String,
    public val createdTime: String,
    public val id: String,
    public val key: KeyVaultKeyReferenceResponse? = null,
    public val location: String? = null,
    public val metadata: Any? = null,
    public val name: String,
    public val publicCertificate: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetIntegrationAccountCertificateResult): GetIntegrationAccountCertificateResult = GetIntegrationAccountCertificateResult(
            changedTime = javaType.changedTime(),
            createdTime = javaType.createdTime(),
            id = javaType.id(),
            key = javaType.key().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.KeyVaultKeyReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            publicCertificate = javaType.publicCertificate().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
