@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The integration account map.
 * @property changedTime The changed time.
 * @property content The content.
 * @property contentLink The content link.
 * @property contentType The content type.
 * @property createdTime The created time.
 * @property id The resource id.
 * @property location The resource location.
 * @property mapType The map type.
 * @property metadata The metadata.
 * @property name Gets the resource name.
 * @property parametersSchema The parameters schema of integration account map.
 * @property tags The resource tags.
 * @property type Gets the resource type.
 */
public data class GetIntegrationAccountMapResult(
    public val changedTime: String,
    public val content: String? = null,
    public val contentLink: ContentLinkResponse,
    public val contentType: String? = null,
    public val createdTime: String,
    public val id: String,
    public val location: String? = null,
    public val mapType: String,
    public val metadata: Any? = null,
    public val name: String,
    public val parametersSchema: IntegrationAccountMapPropertiesResponseParametersSchema? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetIntegrationAccountMapResult): GetIntegrationAccountMapResult = GetIntegrationAccountMapResult(
            changedTime = javaType.changedTime(),
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            contentLink = javaType.contentLink().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.ContentLinkResponse.Companion.toKotlin(args0)
            }),
            contentType = javaType.contentType().map({ args0 -> args0 }).orElse(null),
            createdTime = javaType.createdTime(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            mapType = javaType.mapType(),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            parametersSchema = javaType.parametersSchema().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.IntegrationAccountMapPropertiesResponseParametersSchema.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
