@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The integration account schema.
 * @property changedTime The changed time.
 * @property content The content.
 * @property contentLink The content link.
 * @property contentType The content type.
 * @property createdTime The created time.
 * @property documentName The document name.
 * @property fileName The file name.
 * @property id The resource id.
 * @property location The resource location.
 * @property metadata The metadata.
 * @property name Gets the resource name.
 * @property schemaType The schema type.
 * @property tags The resource tags.
 * @property targetNamespace The target namespace of the schema.
 * @property type Gets the resource type.
 */
public data class GetIntegrationAccountSchemaResult(
    public val changedTime: String,
    public val content: String? = null,
    public val contentLink: ContentLinkResponse,
    public val contentType: String? = null,
    public val createdTime: String,
    public val documentName: String? = null,
    public val fileName: String? = null,
    public val id: String,
    public val location: String? = null,
    public val metadata: Any? = null,
    public val name: String,
    public val schemaType: String,
    public val tags: Map<String, String>? = null,
    public val targetNamespace: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetIntegrationAccountSchemaResult): GetIntegrationAccountSchemaResult = GetIntegrationAccountSchemaResult(
            changedTime = javaType.changedTime(),
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            contentLink = javaType.contentLink().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.ContentLinkResponse.Companion.toKotlin(args0)
            }),
            contentType = javaType.contentType().map({ args0 -> args0 }).orElse(null),
            createdTime = javaType.createdTime(),
            documentName = javaType.documentName().map({ args0 -> args0 }).orElse(null),
            fileName = javaType.fileName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            schemaType = javaType.schemaType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetNamespace = javaType.targetNamespace().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
