@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The integration service environment.
 * @property id The resource id.
 * @property identity Managed service identity properties.
 * @property location The resource location.
 * @property name Gets the resource name.
 * @property properties The integration service environment properties.
 * @property sku The sku.
 * @property tags The resource tags.
 * @property type Gets the resource type.
 */
public data class GetIntegrationServiceEnvironmentResult(
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val properties: IntegrationServiceEnvironmentPropertiesResponse,
    public val sku: IntegrationServiceEnvironmentSkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetIntegrationServiceEnvironmentResult): GetIntegrationServiceEnvironmentResult = GetIntegrationServiceEnvironmentResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.IntegrationServiceEnvironmentPropertiesResponse.Companion.toKotlin(args0)
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.IntegrationServiceEnvironmentSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
