@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The integration account RosettaNet process configuration.
 * @property activitySettings The RosettaNet process configuration activity settings.
 * @property changedTime The changed time.
 * @property createdTime The created time.
 * @property description The integration account RosettaNet ProcessConfiguration properties.
 * @property id The resource id.
 * @property initiatorRoleSettings The RosettaNet initiator role settings.
 * @property location The resource location.
 * @property metadata The metadata.
 * @property name Gets the resource name.
 * @property processCode The integration account RosettaNet process code.
 * @property processName The integration account RosettaNet process name.
 * @property processVersion The integration account RosettaNet process version.
 * @property responderRoleSettings The RosettaNet responder role settings.
 * @property tags The resource tags.
 * @property type Gets the resource type.
 */
public data class GetRosettaNetProcessConfigurationResult(
    public val activitySettings: RosettaNetPipActivitySettingsResponse,
    public val changedTime: String,
    public val createdTime: String,
    public val description: String? = null,
    public val id: String,
    public val initiatorRoleSettings: RosettaNetPipRoleSettingsResponse,
    public val location: String? = null,
    public val metadata: Map<String, String>? = null,
    public val name: String,
    public val processCode: String,
    public val processName: String,
    public val processVersion: String,
    public val responderRoleSettings: RosettaNetPipRoleSettingsResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetRosettaNetProcessConfigurationResult): GetRosettaNetProcessConfigurationResult = GetRosettaNetProcessConfigurationResult(
            activitySettings = javaType.activitySettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.RosettaNetPipActivitySettingsResponse.Companion.toKotlin(args0)
            }),
            changedTime = javaType.changedTime(),
            createdTime = javaType.createdTime(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            initiatorRoleSettings = javaType.initiatorRoleSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.RosettaNetPipRoleSettingsResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            name = javaType.name(),
            processCode = javaType.processCode(),
            processName = javaType.processName(),
            processVersion = javaType.processVersion(),
            responderRoleSettings = javaType.responderRoleSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.RosettaNetPipRoleSettingsResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
