@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The workflow type.
 * @property accessControl The access control configuration.
 * @property accessEndpoint Gets the access endpoint.
 * @property changedTime Gets the changed time.
 * @property createdTime Gets the created time.
 * @property definition The definition.
 * @property endpointsConfiguration The endpoints configuration.
 * @property id The resource id.
 * @property identity Managed service identity properties.
 * @property integrationAccount The integration account.
 * @property integrationServiceEnvironment The integration service environment.
 * @property location The resource location.
 * @property name Gets the resource name.
 * @property parameters The parameters.
 * @property provisioningState Gets the provisioning state.
 * @property sku The sku.
 * @property state The state.
 * @property tags The resource tags.
 * @property type Gets the resource type.
 * @property version Gets the version.
 */
public data class GetWorkflowResult(
    public val accessControl: FlowAccessControlConfigurationResponse? = null,
    public val accessEndpoint: String,
    public val changedTime: String,
    public val createdTime: String,
    public val definition: Any? = null,
    public val endpointsConfiguration: FlowEndpointsConfigurationResponse? = null,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val integrationAccount: ResourceReferenceResponse? = null,
    public val integrationServiceEnvironment: ResourceReferenceResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val parameters: Map<String, WorkflowParameterResponse>? = null,
    public val provisioningState: String,
    public val sku: SkuResponse,
    public val state: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetWorkflowResult): GetWorkflowResult = GetWorkflowResult(
            accessControl = javaType.accessControl().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.FlowAccessControlConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            accessEndpoint = javaType.accessEndpoint(),
            changedTime = javaType.changedTime(),
            createdTime = javaType.createdTime(),
            definition = javaType.definition().map({ args0 -> args0 }).orElse(null),
            endpointsConfiguration = javaType.endpointsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.FlowEndpointsConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            integrationAccount = javaType.integrationAccount().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            integrationServiceEnvironment = javaType.integrationServiceEnvironment().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.logic.kotlin.outputs.WorkflowParameterResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
