@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The encryption key details for the integration service environment.
 * @property keyName Gets the key name in the Key Vault.
 * @property keyVault The key vault reference.
 * @property keyVersion Gets the version of the key specified in the keyName property.
 */
public data class IntegrationServiceEnvironmenEncryptionKeyReferenceResponse(
    public val keyName: String? = null,
    public val keyVault: ResourceReferenceResponse? = null,
    public val keyVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.IntegrationServiceEnvironmenEncryptionKeyReferenceResponse): IntegrationServiceEnvironmenEncryptionKeyReferenceResponse =
            IntegrationServiceEnvironmenEncryptionKeyReferenceResponse(
                keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
                keyVault = javaType.keyVault().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
            )
    }
}
