@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The key vault reference.
 * @property id The resource id.
 * @property name The resource name.
 * @property type The resource type.
 */
public data class KeyVaultKeyReferenceResponseKeyVault(
    public val id: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.KeyVaultKeyReferenceResponseKeyVault): KeyVaultKeyReferenceResponseKeyVault = KeyVaultKeyReferenceResponseKeyVault(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
