@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The key vault key.
 * @property attributes The key attributes.
 * @property kid The key id.
 */
public data class KeyVaultKeyResponse(
    public val attributes: KeyVaultKeyResponseAttributes? = null,
    public val kid: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.KeyVaultKeyResponse): KeyVaultKeyResponse = KeyVaultKeyResponse(
            attributes = javaType.attributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.KeyVaultKeyResponseAttributes.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kid = javaType.kid().map({ args0 -> args0 }).orElse(null),
        )
    }
}
