@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress

/**
 * The key attributes.
 * @property created When the key was created.
 * @property enabled Whether the key is enabled or not.
 * @property updated When the key was updated.
 */
public data class KeyVaultKeyResponseAttributes(
    public val created: Double? = null,
    public val enabled: Boolean? = null,
    public val updated: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.KeyVaultKeyResponseAttributes): KeyVaultKeyResponseAttributes = KeyVaultKeyResponseAttributes(
            created = javaType.created().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            updated = javaType.updated().map({ args0 -> args0 }).orElse(null),
        )
    }
}
