@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Open authentication access policy defined by user.
 * @property claims The access policy claims.
 * @property type Type of provider for OAuth.
 */
public data class OpenAuthenticationAccessPolicyResponse(
    public val claims: List<OpenAuthenticationPolicyClaimResponse>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.OpenAuthenticationAccessPolicyResponse): OpenAuthenticationAccessPolicyResponse = OpenAuthenticationAccessPolicyResponse(
            claims = javaType.claims().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.OpenAuthenticationPolicyClaimResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
