@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The resource reference.
 * @property id The resource id.
 * @property name Gets the resource name.
 * @property type Gets the resource type.
 */
public data class ResourceReferenceResponse(
    public val id: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.ResourceReferenceResponse): ResourceReferenceResponse = ResourceReferenceResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
