@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The RosettaNet ProcessConfiguration business document settings.
 * @property description The business document description.
 * @property name The business document name.
 * @property version The business document version.
 */
public data class RosettaNetPipBusinessDocumentResponse(
    public val description: String? = null,
    public val name: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.RosettaNetPipBusinessDocumentResponse): RosettaNetPipBusinessDocumentResponse = RosettaNetPipBusinessDocumentResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            version = javaType.version(),
        )
    }
}
