@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The sku type.
 * @property name The name.
 * @property plan The reference to plan.
 */
public data class SkuResponse(
    public val name: String,
    public val plan: ResourceReferenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                name = javaType.name(),
                plan = javaType.plan().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
