@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The workflow parameters.
 * @property description The description.
 * @property metadata The metadata.
 * @property type The type.
 * @property value The value.
 */
public data class WorkflowParameterResponse(
    public val description: String? = null,
    public val metadata: Any? = null,
    public val type: String? = null,
    public val `value`: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.WorkflowParameterResponse): WorkflowParameterResponse = WorkflowParameterResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
