@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The workflow trigger recurrence.
 * @property endTime The end time.
 * @property frequency The frequency.
 * @property interval The interval.
 * @property schedule The recurrence schedule.
 * @property startTime The start time.
 * @property timeZone The time zone.
 */
public data class WorkflowTriggerRecurrenceResponse(
    public val endTime: String? = null,
    public val frequency: String? = null,
    public val interval: Int? = null,
    public val schedule: RecurrenceScheduleResponse? = null,
    public val startTime: String? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.WorkflowTriggerRecurrenceResponse): WorkflowTriggerRecurrenceResponse = WorkflowTriggerRecurrenceResponse(
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            frequency = javaType.frequency().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            schedule = javaType.schedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.RecurrenceScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
