@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The X12 agreement acknowledgement settings.
 * @property acknowledgementControlNumberLowerBound The acknowledgement control number lower bound.
 * @property acknowledgementControlNumberPrefix The acknowledgement control number prefix.
 * @property acknowledgementControlNumberSuffix The acknowledgement control number suffix.
 * @property acknowledgementControlNumberUpperBound The acknowledgement control number upper bound.
 * @property batchFunctionalAcknowledgements The value indicating whether to batch functional acknowledgements.
 * @property batchImplementationAcknowledgements The value indicating whether to batch implementation acknowledgements.
 * @property batchTechnicalAcknowledgements The value indicating whether to batch the technical acknowledgements.
 * @property functionalAcknowledgementVersion The functional acknowledgement version.
 * @property implementationAcknowledgementVersion The implementation acknowledgement version.
 * @property needFunctionalAcknowledgement The value indicating whether functional acknowledgement is needed.
 * @property needImplementationAcknowledgement The value indicating whether implementation acknowledgement is needed.
 * @property needLoopForValidMessages The value indicating whether a loop is needed for valid messages.
 * @property needTechnicalAcknowledgement The value indicating whether technical acknowledgement is needed.
 * @property rolloverAcknowledgementControlNumber The value indicating whether to rollover acknowledgement control number.
 * @property sendSynchronousAcknowledgement The value indicating whether to send synchronous acknowledgement.
 */
public data class X12AcknowledgementSettingsResponse(
    public val acknowledgementControlNumberLowerBound: Int,
    public val acknowledgementControlNumberPrefix: String? = null,
    public val acknowledgementControlNumberSuffix: String? = null,
    public val acknowledgementControlNumberUpperBound: Int,
    public val batchFunctionalAcknowledgements: Boolean,
    public val batchImplementationAcknowledgements: Boolean,
    public val batchTechnicalAcknowledgements: Boolean,
    public val functionalAcknowledgementVersion: String? = null,
    public val implementationAcknowledgementVersion: String? = null,
    public val needFunctionalAcknowledgement: Boolean,
    public val needImplementationAcknowledgement: Boolean,
    public val needLoopForValidMessages: Boolean,
    public val needTechnicalAcknowledgement: Boolean,
    public val rolloverAcknowledgementControlNumber: Boolean,
    public val sendSynchronousAcknowledgement: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.X12AcknowledgementSettingsResponse): X12AcknowledgementSettingsResponse = X12AcknowledgementSettingsResponse(
            acknowledgementControlNumberLowerBound = javaType.acknowledgementControlNumberLowerBound(),
            acknowledgementControlNumberPrefix = javaType.acknowledgementControlNumberPrefix().map({ args0 ->
                args0
            }).orElse(null),
            acknowledgementControlNumberSuffix = javaType.acknowledgementControlNumberSuffix().map({ args0 ->
                args0
            }).orElse(null),
            acknowledgementControlNumberUpperBound = javaType.acknowledgementControlNumberUpperBound(),
            batchFunctionalAcknowledgements = javaType.batchFunctionalAcknowledgements(),
            batchImplementationAcknowledgements = javaType.batchImplementationAcknowledgements(),
            batchTechnicalAcknowledgements = javaType.batchTechnicalAcknowledgements(),
            functionalAcknowledgementVersion = javaType.functionalAcknowledgementVersion().map({ args0 ->
                args0
            }).orElse(null),
            implementationAcknowledgementVersion = javaType.implementationAcknowledgementVersion().map({ args0 ->
                args0
            }).orElse(null),
            needFunctionalAcknowledgement = javaType.needFunctionalAcknowledgement(),
            needImplementationAcknowledgement = javaType.needImplementationAcknowledgement(),
            needLoopForValidMessages = javaType.needLoopForValidMessages(),
            needTechnicalAcknowledgement = javaType.needTechnicalAcknowledgement(),
            rolloverAcknowledgementControlNumber = javaType.rolloverAcknowledgementControlNumber(),
            sendSynchronousAcknowledgement = javaType.sendSynchronousAcknowledgement(),
        )
    }
}
