@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The X12 delimiter override settings.
 * @property componentSeparator The component separator.
 * @property dataElementSeparator The data element separator.
 * @property messageId The message id.
 * @property protocolVersion The protocol version.
 * @property replaceCharacter The replacement character.
 * @property replaceSeparatorsInPayload The value indicating whether to replace separators in payload.
 * @property segmentTerminator The segment terminator.
 * @property segmentTerminatorSuffix The segment terminator suffix.
 * @property targetNamespace The target namespace on which this delimiter settings has to be applied.
 */
public data class X12DelimiterOverridesResponse(
    public val componentSeparator: Int,
    public val dataElementSeparator: Int,
    public val messageId: String? = null,
    public val protocolVersion: String? = null,
    public val replaceCharacter: Int,
    public val replaceSeparatorsInPayload: Boolean,
    public val segmentTerminator: Int,
    public val segmentTerminatorSuffix: String,
    public val targetNamespace: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.X12DelimiterOverridesResponse): X12DelimiterOverridesResponse = X12DelimiterOverridesResponse(
            componentSeparator = javaType.componentSeparator(),
            dataElementSeparator = javaType.dataElementSeparator(),
            messageId = javaType.messageId().map({ args0 -> args0 }).orElse(null),
            protocolVersion = javaType.protocolVersion().map({ args0 -> args0 }).orElse(null),
            replaceCharacter = javaType.replaceCharacter(),
            replaceSeparatorsInPayload = javaType.replaceSeparatorsInPayload(),
            segmentTerminator = javaType.segmentTerminator(),
            segmentTerminatorSuffix = javaType.segmentTerminatorSuffix(),
            targetNamespace = javaType.targetNamespace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
